<?php
/*--------------------------------------------------------------------------------------------------
    PropertyReadRepositoryInterface.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\Database\Repositories\Interfaces;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\Builders\Interfaces\SellingUnitIdBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;

interface PropertyReadRepositoryInterface
{
    /**
     * @param ProductId $productId
     *
     * @return mixed
     */
    public function hasProperties(ProductId $productId);
    
    
    /**
     * @param int                           $combinationId
     *
     * @param SellingUnitIdBuilderInterface $builder
     *
     * @return void
     */
    public function addPropertyInfoToBuilder(int $combinationId, SellingUnitIdBuilderInterface $builder): void;
    
    
    /**
     * @param SellingUnitId $id
     *
     * @return mixed
     */
    public function getCombinationsFor(SellingUnitId $id);
    
}